-------------------------------------------------------
-- Created by Ben Cope of Imperial College (June 2005)
-- Evaluate multiplication Block for Filter 7x7
-------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_arith.ALL;

LIBRARY work;
USE work.Constants.ALL;
USE work.ALL;

ENTITY Evaluate IS
    PORT (clock : IN STD_LOGIC;
          reset : IN STD_LOGIC;
			 RGB_compute : IN Channel_nxn;
			 compute : IN STD_LOGIC;
			 output_valid: OUT STD_LOGIC;
			 output : OUT VectorRGB);
END Evaluate;

ARCHITECTURE inside OF Evaluate IS

SIGNAL result : VectorRes_nxn;
SIGNAL min0, min1 : VectorRGB_ex;
SIGNAL min : VectorRGB_ex_nxn;
SIGNAL result_small_pr : VectorRGB_ex_nxn;
SIGNAL result_small : VectorRGB_ex_nxn;
SIGNAL rounding : VectorRGB_ex_nxn;
SIGNAL pre_output : VectorRGB_ex;

SIGNAL valid: STD_LOGIC_VECTOR(0 TO 10);

BEGIN

 --------------------------------------------
 -- MULTIPLIER INSTANTIATIONS
 --------------------------------------------

G1: FOR i IN 0 TO n-1 GENERATE -- width n
 G2: FOR j IN 0 TO n-1 GENERATE -- height n
  G3: FOR k IN 0 TO 2 GENERATE -- For each RGB
   M1: ENTITY Multiplier_model
   PORT MAP(
    P => result(i)(j)(k),
 	 A => RGB_compute(i)(j).RGB(k),
	 B => matrix(i)(j),
	 C => clock,
	 CE => '1',
	 R => reset);
  END GENERATE;
 END GENERATE;
END GENERATE;

 --------------------------------------------
 -- ADDER TREE
 --------------------------------------------

P1: PROCESS 
BEGIN
 WAIT UNTIL Rising_Edge(clock);

 IF reset = '1' THEN
	
	FOR k IN 0 TO 2 LOOP
	 output(k) <= (OTHERS => '0');
	END LOOP;
 
 ELSE
 
  -- Multiplication (3 Cycle delay)

  
   -- Rounding (2 cycle delay)

   FOR i IN 0 TO n-1 LOOP
    FOR j IN 0 TO n-1 LOOP
	  FOR k IN 0 TO 2 LOOP
		result_small_pr(i)(j)(k) <= result(i)(j)(k)(RGB_width*2-2 DOWNTO RGB_width*2-2-RGB_width);
 	   rounding(i)(j)(k) <= "00000000" & result(i)(j)(k)(RGB_width*2-2-RGB_width-1);
 	   result_small(i)(j)(k) <= signed(result_small_pr(i)(j)(k)) + signed(rounding(i)(j)(k));
	  END LOOP;
	 END LOOP;
   END LOOP;
 
  -- Perform Additions (change for each n)
  
  FOR k IN 0 TO 2 LOOP
   
   -- 1 cycle delay
    min(0)(0)(k) <= signed(result_small(0)(0)(k)) + signed(result_small(0)(1)(k));
	 min(0)(1)(k) <= signed(result_small(0)(2)(k)) + signed(result_small(0)(3)(k));
	 min(0)(2)(k) <= signed(result_small(0)(4)(k)) + signed(result_small(0)(5)(k));
	 min(0)(3)(k) <= signed(result_small(0)(6)(k)) + signed(result_small(1)(0)(k));
	 min(0)(4)(k) <= signed(result_small(1)(1)(k)) + signed(result_small(1)(2)(k));
	 min(0)(5)(k) <= signed(result_small(1)(3)(k)) + signed(result_small(1)(4)(k));
	 min(0)(6)(k) <= signed(result_small(1)(5)(k)) + signed(result_small(1)(6)(k));

	 min(1)(0)(k) <= signed(result_small(2)(0)(k)) + signed(result_small(2)(1)(k));
	 min(1)(1)(k) <= signed(result_small(2)(2)(k)) + signed(result_small(2)(3)(k));
	 min(1)(2)(k) <= signed(result_small(2)(4)(k)) + signed(result_small(2)(5)(k));
	 min(1)(3)(k) <= signed(result_small(2)(6)(k)) + signed(result_small(3)(0)(k));
	 min(1)(4)(k) <= signed(result_small(3)(1)(k)) + signed(result_small(3)(2)(k));
	 min(1)(5)(k) <= signed(result_small(3)(3)(k)) + signed(result_small(3)(4)(k));
	 min(1)(6)(k) <= signed(result_small(3)(5)(k)) + signed(result_small(3)(6)(k));

	 min(2)(0)(k) <= signed(result_small(4)(0)(k)) + signed(result_small(4)(1)(k));
	 min(2)(1)(k) <= signed(result_small(4)(2)(k)) + signed(result_small(4)(3)(k));
	 min(2)(2)(k) <= signed(result_small(4)(4)(k)) + signed(result_small(4)(5)(k));
	 min(2)(3)(k) <= signed(result_small(4)(6)(k)) + signed(result_small(5)(0)(k));
	 min(2)(4)(k) <= signed(result_small(5)(1)(k)) + signed(result_small(5)(2)(k));
	 min(2)(5)(k) <= signed(result_small(5)(3)(k)) + signed(result_small(5)(4)(k));
	 min(2)(6)(k) <= signed(result_small(5)(5)(k)) + signed(result_small(5)(6)(k));

	 min(3)(0)(k) <= signed(result_small(6)(0)(k)) + signed(result_small(6)(1)(k));
	 min(3)(1)(k) <= signed(result_small(6)(2)(k)) + signed(result_small(6)(3)(k));
	 min(3)(2)(k) <= signed(result_small(6)(4)(k)) + signed(result_small(6)(5)(k));
	 min(3)(3)(k) <= result_small(6)(6)(k);

   -- 1 cycle delay
	 min(3)(4)(k) <= signed(min(0)(0)(k)) + signed(min(0)(1)(k));
	 min(3)(5)(k) <= signed(min(0)(2)(k)) + signed(min(0)(3)(k));
	 min(3)(6)(k) <= signed(min(0)(4)(k)) + signed(min(0)(5)(k));
	 
	 min(4)(0)(k) <= signed(min(0)(6)(k)) + signed(min(1)(0)(k));
	 min(4)(1)(k) <= signed(min(1)(1)(k)) + signed(min(1)(2)(k));
	 min(4)(2)(k) <= signed(min(1)(3)(k)) + signed(min(1)(4)(k));
	 min(4)(3)(k) <= signed(min(1)(5)(k)) + signed(min(1)(6)(k));
	 min(4)(4)(k) <= signed(min(2)(0)(k)) + signed(min(2)(1)(k));
	 min(4)(5)(k) <= signed(min(2)(2)(k)) + signed(min(2)(3)(k));
	 min(4)(6)(k) <= signed(min(2)(4)(k)) + signed(min(2)(5)(k));

	 min(5)(0)(k) <= signed(min(2)(6)(k)) + signed(min(3)(0)(k));
	 min(5)(1)(k) <= signed(min(3)(1)(k)) + signed(min(3)(2)(k));
	 min(5)(2)(k) <= min(3)(3)(k);

	-- 1 cycle delay
	 min(5)(3)(k) <= signed(min(3)(4)(k)) + signed(min(3)(5)(k));
	 min(5)(4)(k) <= signed(min(3)(6)(k)) + signed(min(4)(0)(k));
	 min(5)(5)(k) <= signed(min(4)(1)(k)) + signed(min(4)(2)(k));
	 min(5)(6)(k) <= signed(min(4)(3)(k)) + signed(min(4)(4)(k));

	 min(6)(0)(k) <= signed(min(4)(5)(k)) + signed(min(4)(6)(k));
	 min(6)(1)(k) <= signed(min(5)(0)(k)) + signed(min(5)(1)(k));
	 min(6)(2)(k) <= min(5)(2)(k);

	-- 1 cycle delay
	 min(6)(3)(k) <= signed(min(5)(3)(k)) + signed(min(5)(4)(k));
	 min(6)(4)(k) <= signed(min(5)(5)(k)) + signed(min(5)(6)(k));
	 min(6)(5)(k) <= signed(min(6)(0)(k)) + signed(min(6)(1)(k));
	 min(6)(6)(k) <= min(6)(2)(k);

	-- 1 cycle delay
	 min0(k) <= signed(min(6)(3)(k)) + signed(min(6)(4)(k));
	 min1(k) <= signed(min(6)(5)(k)) + signed(min(6)(6)(k));

   -- 2 cycle delay
	 Pre_output(k) <= signed(min0(k)) + signed(min1(k));
	 output(k) <= Pre_output(k)(RGB_width-1 DOWNTO 0);
  END LOOP;
 END IF;

END PROCESS P1;

--------------------------------------------
 -- Organise Valid Signals
 --------------------------------------------

valid_proc: PROCESS

BEGIN

  WAIT UNTIL Rising_Edge(clock);

  IF reset = '1' THEN
	
   valid <= (OTHERS => '0');
	output_valid <= '0';
  ELSE
 
 -- ORGANISE VALID 
 valid(0) <= compute AND RGB_compute(3)(3).valid;
 valid(1 TO 10) <= valid(0 TO 9);
 output_valid <= valid(10);

 END IF;

END PROCESS valid_proc;


END inside;

